// Outfit No. 1 Models
// Model 1.4 - Garage Crane - Grue de garage - Garage Kraan - Werkstattkran - Gru per autorimessa  
// Uses coil.inc by Chris Colefax for rope coil 
// Alan Jardine, Kintore
// Version 0 - Started - 2001-10-07 
// Version 0.1 - - 2002-01-02 
// Version 0.2 - Platform Assembly Complete - 2002-01-03      
// Version 0.3 - Main Jib elements Complete and roughly positioned - 2002-01-06 
// Version 0.4 - Front Jib Strut & Crank Assembly complete - 2002-01-12 
// Version 0.5 - Main structure complete - Needs to be Strung - 2002-01-12 
// Version 1.0 - Model Complete - 2002-01-12
// Version 1.1 - Made into an Include File - 2004-10-28

// Parts List - included for the record and as a possible future way of parameterising
// Meccano.inc to reduce parse time

/*
2,,Perforated strip,"5 """,4
5,,Perforated strip,"2 """,2
10,,Fishplate,,2
11,,Double bracket,""" x """,1
12,,Angle bracket,""" x """,2
16,,Axle rod,"3 """,1
19s,,Crank handle,"3 """,1
22,,Pulley,"1""",2
24,,Bush wheel 8 hole,"1 3/8""",1
35,,Spring clip,,2
37a,,Nut,,24
37b,,Bolt,"7/32""",21
38,,Washer,"3/8""",6
40,,Hank of cord,,1
48a,,Double angle strip,"2 "" x  """,2
57c,,Hook loaded (waisted),,1
90a,,Curved strip stepped,"2 """,2
111c,,Bolt,"3/8""",2
126,,Trunnion,,2
126a,,Flat trunnion,,2
142c,,Tyre,"1""",2
194,,Plastic plate,"2 "" x 1 """,1
*/


#declare GarageCrane = 
union { // Entire Model   
       
       union { // Jib
              union { // Front Half of Main Structure
                     union {
                            object {Part90a}
                            object {Part37z translate <0.95,1.325,0>}
                            union { // Cord & Hook
                                   cylinder {<0, 0,0> <0, -4,0> 0.03  }
                                   sphere {<0,-4,0> 0.1 pigment {Black}} // Knot 
                                   object {Part57c translate -4.6*y} // Hook
                                   rotate -45*z // Compensation to hang vertically
                                   translate <1,1.35,0.1>
                                  } 
                            rotate -30*z translate <0.725, -1.65, 0.02>
                            
                           } 
                     object {Part5}
                     object {Part37x translate 1*x}  
                     object {Part37x rotate 180*x translate 0.5*x}
                     union {
                            object {Part2 }
                            object {Part37x translate  2.5*x}
                            object {Part37z translate -2.5*x}
                            object {Part37x translate    2*x}
                            translate <-3, 0, -0>
                           } 
                     rotate -1.5*y
                     translate -0.2*z
                    } 
                    
              union { // Back Half  of Main Structure
                     object {Part90a rotate -30*z translate <0.725, -1.65, -0.02>}
                     object {Part5}
                     object {Part37x rotate 180*x translate 1*x}  
                     object {Part37x translate 0.5*x}
                     union {
                             object {Part2 }
                             object {Part37x rotate 180*x translate  2.5*x}
                             object {Part37z rotate 180*x translate -2.5*x}
                             object {Part37x rotate 180*x translate    2*x}
                            translate <-3, 0, 0>
                           } 
                     rotate 1.5*y
                     translate 0.2*z
                    } 
             
             rotate <0, 90,0> 
             rotate -22*x
             translate <0,-1.6,-5.5> 
             
             } // End of Jib
  
             union { // Struts & Crank
                     union { // Front Strut
                             object {Part2}
                             object {Part37z translate -2.5*x} 
                             object {Part37z translate  2.5*x}
                             rotate -12*y
                             translate -0.85*z
                           }
                           
                     union { // Back Strut
                             object {Part2}
                             object {Part37z translate -2.5*x} 
                             object {Part37z translate  2.5*x}
                             rotate 180*x
                             rotate 12*y
                             translate  0.85*z
                           }      
                             
                     union { // Crank
                            object {Part19s}
                            object {Part35 translate  1.6*x}
                            object {Part38 translate 1.4*x}
                            object {Part35 translate -1.6*x}
                            object {Part38 translate -1.4*x} 
                            union {
                                   #declare coil_point1 = <0, 0, 0>;
                                   #declare coil_point2 = <0, 0, 1.1>;
                                   #declare coil_type = 2;                  
                                   #declare coil_radius = 0.1;
                                   #declare coil_radius2 = 0.1;
                                   #declare coil_thickness = 0.03;
                                   #declare coil_thickness2 = 0.03;   
                                   #declare coil_revolutions =  13;  
                                   #declare coil_smoothness = 36;
                                   #include "C:\BigBoyD\Alans POV Scenes\coil.inc" 
                                   cylinder { <0,0.0> <0,-8,0>   0.03} // First Part of string
                                   pigment {Black}
                                   rotate 90*y
                                  } 
                            rotate 90*z rotate 90*x
                            rotate -2*z // Adjust string angle
                            translate -1.5*x
                           
                           }  
                     rotate 90*y
                     rotate -31.5*x
                     translate <0,0.2,-2>
                   }          
 
  
       union { // Platform Assembly
                
                
              
                union { // Main Axle and Wheels 
                       object {Part16}
                       object {Part22 rotate  90*y translate -1.75*x}
                       object {Part142c rotate <90,90,0> translate -1.75*x}
                       object {Part22 rotate  -90*y translate  1.75*x}
                       object {Part142c rotate <90,90,0> translate  1.75*x}                           
                       //rotate 90*y                                             // Possible Animation variable
                                                             
                      }              
              
              
                union { // Platform
                      union{ // Front Member
                              object {Part48a}
                              object {Part37x rotate  90*y translate <-1.225, 0, -0.25>} 
                              object {Part10 rotate <90, 0, -90> translate <-1.225, 0.25, -0.25>}
                              object {Part37x rotate -90*y translate <1.225, 0, -0.25>}
                              object {Part10 rotate <90, 0, -90> translate <1.225, 0.25, -0.25>} 
                              rotate -90*z
                              translate <0.5, 0, -0.02>    
                            }
                       union{ // Rear Member
                              object {Part48a}
                              rotate -90*z
                              translate <-0.5, 0, -0.02>    
                            }
                       
                       object {Part126a rotate  90*z translate -0.5*x} // Front Flat Trunnion     
                       
                       object {Part126a rotate -90*z translate <-0.5, 0, -0.04>} // Rear  Flat Trunnion
                       object {Part37x rotate 180*x translate -1.5*x}    
                       
                       union { // Platform Base
                              object {Part194}
                              object {Part37y translate 0.5*y}
                              object {Part37y translate <0.5, -0.5, 0>}
                              object {Part37y translate <-0.5, -0.5, 0>}
                              object {Part11 translate <0, 0.5, -0.02>} // Supporting Bracket for jib
                              rotate 90*z rotate 180*y
                             }
                    
                       union { // Rear Wheel and Bearing Assembly
                               object {Part125 rotate 90*y translate <-1.75, 0 , 0.25>} // Cheat - should be 2 x 12s
                               union { // Lower Trunnion & stub Axle
                                      object {Part126 translate -0.25*z}  
                                      object {Part126 rotate 180*y translate <0,0.025,0.25>}
                                      object {Part111c translate <0,-0.75, -0.25>} 
                                      object {Part24 rotate 180*y translate <0,-0.75, 0.125>}  
                                      object {Part37z rotate 90*x translate <0.5,0.04,0>}
                                      rotate 90*x
                                      translate <-2.5,0,0.55>
                                     }   
                             
                             }    
                      rotate <180,0,-90> 
                      translate <0,1,-0.25>
                      }
                      
                      
               
              } // End of Platform Assembly

rotate <90, -90, 6> // Normalise Model on Ground Plane
rotate 60*y

} // End of Entire Model